// Mock product data - in a real app, this would come from an API or database
export const products = [
	{
		id: 1,
		name: "Diazepam 10mg",
		slug: "diazepam-10mg-kopen",
		price: 70,
		originalPrice: 85,
		category: "Medicijnen",
		categories: ["Medicijnen"],
		stock: 120,
		image: "/images/products/diazepam-10mg.jpg",
		shortDescription:
			"<strong>1 doos Diazepam 10mg bevat 30 tabletten</strong><ul class='list-disc list-inside'><li>Bevordert sneller inslapen</li><li>Verlengt de slaapduur</li><li>Werkt binnen 1 uur en blijft 8-12 uur actief</li><li>Kalmerend, spierontspannend en vermindert angstgevoelens</li></ul>",

		description: `
<h2 class='text-[32px] font-medium mb-4 mt-2'>Wat is Diazepam 10mg?</h2>
<p>Diazepam 10mg is een geneesmiddel uit de <a href='/' class='text-[#7f54b3] hover:text-[#0e1703]'>benzodiazepinen</a>-groep. Het wordt voorgeschreven voor de behandeling van diverse aandoeningen zoals angststoornissen, slapeloosheid, spierspasmen en bepaalde vormen van epilepsie. Diazepam werkt kalmerend en spierontspannend doordat het de activiteit van het centrale zenuwstelsel onderdrukt. Het versterkt het effect van gamma-aminoboterzuur (GABA), een neurotransmitter die een remmende werking heeft op de hersenen.</p>
<h3 class='mt-4 mb-2'>Toepassingen van Diazepam:</h3>
<ol class='list-disc list-inside pl-6 mb-4'>
  <li><strong>Angstklachten:</strong> Helpt bij het verminderen van overmatige angst, paniekaanvallen en spanningsgevoelens.</li>
  <li><strong>Slapeloosheid:</strong> Wordt gebruikt om in slaap te vallen of door te slapen bij ernstige slaapproblemen veroorzaakt door stress of angst.</li>
  <li><strong>Spierkrampen:</strong> Verlicht spierspanning bij aandoeningen zoals rugpijn of neurologische stoornissen.</li>
  <li><strong>Sedatie:</strong> Toegepast voorafgaand aan chirurgische of tandheelkundige ingrepen om angst te verminderen.</li>
  <li><strong>Alcoholontwenning:</strong> Vermindert ontwenningsverschijnselen zoals prikkelbaarheid, trillen of epileptische aanvallen.</li>
  <li><strong>Epilepsie:</strong> Wordt gebruikt om acute aanvallen te behandelen of te voorkomen, vaak als noodmedicatie.</li>
</ol>
<h3 class='mt-4 mb-2'>Dosering en gebruik</h3>
<p>De gebruikelijke dosis voor volwassenen is 10 mg, maar de exacte hoeveelheid hangt af van de indicatie, de ernst van de symptomen en de individuele respons. Diazepam wordt meestal oraal ingenomen, met of zonder voedsel. Het is belangrijk om altijd het voorschrift van een arts te volgen. De dosering bij ouderen en mensen met leverproblemen is doorgaans lager.</p>
<h3 class='mt-4 mb-2'>Werkingsduur</h3>
<p>Diazepam begint meestal binnen 30 tot 60 minuten te werken. De effecten houden gemiddeld 8 tot 12 uur aan, maar kunnen langer aanhouden vanwege de lange halfwaardetijd. Diazepam kan zich in het lichaam opstapelen bij langdurig gebruik, waardoor het effect verlengd wordt.</p>
<h3 class='mt-4 mb-2'>Bijwerkingen</h3>
<ul class='list-disc pl-6 mb-4'>
  <li>Slaperigheid, sufheid en verminderde concentratie</li>
  <li>Duizeligheid, evenwichtsstoornissen en spierzwakte</li>
  <li>Verwardheid en geheugenproblemen, vooral bij ouderen</li>
  <li>Verlaagde reactietijd, wat het risico op vallen verhoogt</li>
  <li>Afhankelijkheid en ontwenningsverschijnselen bij langdurig gebruik</li>
</ul>
<h3 class='mt-4 mb-2'>Voorzorgsmaatregelen</h3>
<ul class='list-disc pl-6 mb-4'>
  <li>Niet combineren met alcohol of andere kalmerende middelen; dit verhoogt het risico op ademhalingsdepressie en bewusteloosheid.</li>
  <li>Vermijd het besturen van voertuigen of het bedienen van machines na inname.</li>
  <li>Gebruik onder strikte medische begeleiding, vooral bij mensen met een voorgeschiedenis van verslaving.</li>
  <li>Nooit plotseling stoppen met Diazepam, omdat dit tot ernstige ontwenningsverschijnselen kan leiden. Altijd geleidelijk afbouwen.</li>
  <li>Niet geschikt voor langdurig dagelijks gebruik vanwege gewenning en afhankelijkheid.</li>
</ul>
<h3 class='mt-4 mb-2'>Interacties met andere middelen</h3>
<p>Diazepam kan interageren met andere geneesmiddelen zoals antidepressiva, antipsychotica, opioïden, slaapmiddelen en alcohol. Deze interacties kunnen het sedatieve effect versterken en gevaarlijke bijwerkingen veroorzaken zoals ademhalingsproblemen. Informeer je arts over alle medicatie die je gebruikt.</p>
<h3 class='mt-4 mb-2'>Verslavingsrisico</h3>
<p>Langdurig of overmatig gebruik van Diazepam kan leiden tot lichamelijke en psychische afhankelijkheid. Dit risico is groter bij mensen met een geschiedenis van middelenmisbruik. Symptomen van verslaving kunnen zijn: verhoogde tolerantie, het gevoel het middel nodig te hebben, en ontwenningsverschijnselen bij stoppen.</p>
<h2 class='text-[32px] font-medium mb-4 mt-2'>Diazepam 10mg online kopen</h2>
<p>Bij ons kunt u Diazepam 10mg veilig en discreet online bestellen. Wij garanderen snelle levering en respecteren uw privacy. Onze betrouwbare online apotheek biedt scherpe prijzen en extra korting bij grotere bestellingen.</p>
<p>Alle bestellingen worden zorgvuldig verpakt en verzonden met respect voor uw vertrouwelijkheid. Bij vragen of advies staan onze specialisten voor u klaar.</p>
<p>Bestel vandaag nog en ontdek het gemak en de betrouwbaarheid van het kopen van Diazepam 10mg online via een erkende aanbieder.</p>
`,
	},
	// added
	{
		id: 2,
		name: "Zolpidem 10mg",
		slug: "zolpidem-10mg-kopen",
		price: 70,
		originalPrice: 85,
		stock: 120,
		category: "Medicijnen",
		categories: ["Medicijnen"],
		image: "/images/products/zolpidem-10mg.jpg",
		shortDescription:
			"<strong>Een doosje Zolpidem 10mg bevat 30 tabletten</strong>\n<ul>\n  <li>Effectieve behandeling van slapeloosheid</li>\n  <li>Werkt rustgevend en angstremmend</li>\n  <li>Snel effect binnen 30 minuten</li>\n  <li>Werkingsduur van 6 tot 8 uur</li>\n  <li>Aanbevolen dosis: 10 mg voor volwassenen</li>\n</ul>",

		description: `<h2 class="text-[32px] font-medium mb-4 mt-2">Zolpidem 10mg – Effectieve oplossing bij slapeloosheid</h2>
      <p>Zolpidem 10mg behoort tot de klasse van zogenaamde Z-drugs, die speciaal zijn ontwikkeld voor de behandeling van slaapstoornissen. Het middel werkt snel en krachtig en wordt vaak ingezet bij mensen die moeite hebben met inslapen of te vroeg wakker worden. Zolpidem bevordert een diepere en rustgevende slaap zonder dat je er de volgende dag suf van bent. Het is een uitstekende keuze voor mensen die tijdelijk hulp nodig hebben om hun slaappatroon te herstellen.</p>
      
      <div class="flex flex-col gap-[14.4px] my-4">
        <p><strong>Toepassing:</strong> Zolpidem is bedoeld voor de kortdurende behandeling van slapeloosheid. Het helpt bij het sneller inslapen en zorgt voor een verbeterde nachtrust. Dit geneesmiddel biedt effectieve verlichting voor mensen die last hebben van slapeloosheid door stress, reisgerelateerde slaapstoornissen, of andere tijdelijke factoren.</p>
      
        <p><strong>Werking:</strong> De werking begint meestal al binnen 30 minuten na inname. De werkingsduur ligt tussen de 6 en 8 uur, waardoor je een volledige nacht kunt doorslapen. Het heeft een kalmerend effect op het centrale zenuwstelsel en zorgt ervoor dat je diep en ononderbroken slaapt.</p>
      
        <p><strong>Dosering:</strong> Voor volwassen gebruikers is de standaarddosering 10 mg. Bij ouderen of mensen met een verminderde gezondheid wordt vaak gestart met 5 mg om de kans op bijwerkingen te beperken. Het is essentieel om de aanbevolen dosering van je arts op te volgen om de effectiviteit te waarborgen en bijwerkingen te voorkomen.</p>
      
        <p><strong>Gebruik:</strong> Neem Zolpidem vlak voor het slapengaan in, bij voorkeur op een lege maag voor optimale werking. Gebruik het medicijn uitsluitend voor een korte periode van maximaal enkele weken. Langdurig gebruik kan leiden tot gewenning of verslaving.</p>
      
        <p><strong>Mogelijke bijwerkingen:</strong> Je kunt last krijgen van lichte duizeligheid, hoofdpijn of slaperigheid overdag. In zeldzame gevallen zijn slaapwandelen of geheugenverlies gemeld. Raadpleeg bij aanhoudende klachten je arts. Het is belangrijk om alert te blijven bij het gebruik van Zolpidem, vooral de eerste keren, om te zien hoe je lichaam erop reageert.</p>
      </div>
      
      <h3 class="text-xl font-semibold mt-6 mb-2">Belangrijke waarschuwingen</h3>
      <ul class="list-disc pl-10 mb-4">
        <li>Gebruik Zolpidem niet in combinatie met alcohol of andere slaapmiddelen, omdat dit de werking kan versterken en gevaarlijk kan zijn.</li>
        <li>Vermijd autorijden of het bedienen van machines na gebruik, aangezien het effect van Zolpidem het reactievermogen kan beïnvloeden.</li>
        <li>Volg altijd de doseringsinstructies van je arts nauwgezet op om onbedoelde bijwerkingen te voorkomen.</li>
        <li>Laat je arts weten welke andere medicijnen of supplementen je gebruikt, omdat Zolpidem in combinatie met bepaalde stoffen onvoorspelbare reacties kan veroorzaken.</li>
      </ul>
      
      <p>Wil je Zolpidem 10mg veilig en discreet online kopen? Bij ons ben je verzekerd van kwaliteit, betrouwbaarheid en een eenvoudige bestelprocedure. Je privacy staat bij ons altijd voorop, en wij zorgen voor een discrete en veilige verzending van je bestelling.</p>
      
      <h2 class="text-[32px] font-medium mb-4 mt-2">Waarom Zolpidem 10mg bij ons kopen?</h2>
      <div class="flex flex-col gap-[14.4px]">
        <p>Wij zijn dé betrouwbare aanbieder van Zolpidem 10mg. Profiteer van directe betaling via iDEAL, snelle levering en aantrekkelijke kortingen bij grotere bestellingen. Wij bieden uitstekende klantenservice en zorgen ervoor dat je bestelling snel en veilig bij je thuis wordt bezorgd.</p>
        <p>Of je nu voor particulier gebruik koopt of een groothandelsbestelling plaatst – bij ons staat veiligheid, gemak en kwaliteit altijd voorop. Al onze producten zijn van hoge kwaliteit en voldoen aan de strikte richtlijnen voor medicijnverkoop.</p>
        <p>Maak vandaag nog je keuze voor betrouwbare online service en bestel Zolpidem 10mg eenvoudig bij ons. Geniet van een betere nachtrust en voel je de volgende ochtend verfrist en energiek!</p>
      </div>`,
	},
	// added
	// 	{
	// 		id: 3,
	// 		name: "Temazepam 20mg",
	// 		slug: "temazepam-20mg-kopen",
	// 		price: 100,
	// 		originalPrice: 120,
	// 		stock: 50,
	// 		category: "Medicijnen",
	// 		categories: ["Medicijnen"],
	// 		image: "/images/products/Temazepam20mg.webp",
	// 		shortDescription: `
	//     <strong>Zolpidem 10mg - 30 tabletten per doosje</strong>
	//     <ul>
	//       <li>Sterk slaapmiddel uit de Z-drug categorie</li>
	//       <li>Voor kortdurende behandeling van slapeloosheid</li>
	//       <li>Snelle werking: binnen 30 minuten</li>
	//       <li>Werkt tot 8 uur</li>
	//       <li>Gebruik alleen voor het slapengaan</li>
	//     </ul>
	//   `,
	// 		description: `
	//   <h2 class="text-[32px] font-medium mb-4 mt-2">Zolpidem 10mg – Snelwerkend slaapmiddel</h2>
	//   <p>Heb je last van slapeloosheid? <strong>Zolpidem 10mg</strong> helpt je sneller in slaap te vallen en beter door te slapen. Dit krachtige slaapmiddel behoort tot de Z-drugs, een groep geneesmiddelen die specifiek zijn ontwikkeld voor de behandeling van slaapstoornissen. Zolpidem wordt vaak voorgeschreven voor kortdurend gebruik bij ernstige slaapproblemen en biedt een snelle en effectieve oplossing voor mensen die moeite hebben met inslapen of vaak te vroeg wakker worden. Het zorgt voor een diepe en rustgevende slaap, zonder dat je de volgende dag last hebt van slaperigheid of een duf gevoel.</p>

	//   <h3 class="text-xl font-semibold mt-6 mb-2">Voordelen van Zolpidem</h3>
	//   <ul class="list-disc pl-5">
	//     <li><strong>Snelle werking:</strong> De werking van Zolpidem begint al binnen 30 minuten na inname, waardoor je snel in slaap valt zonder lang te hoeven wachten.</li>
	//     <li><strong>Effectief gedurende 6-8 uur:</strong> Zolpidem heeft een werkingsduur van 6 tot 8 uur, waardoor je een volledige nacht kunt doorslapen zonder onderbrekingen.</li>
	//     <li><strong>Helpt bij inslaapproblemen en nachtelijk ontwaken:</strong> Het helpt je niet alleen sneller in slaap te vallen, maar voorkomt ook dat je midden in de nacht wakker wordt.</li>
	//     <li><strong>Geen last van ochtenddips:</strong> In tegenstelling tot andere slaapmiddelen, zorgt Zolpidem ervoor dat je de volgende ochtend niet moe of duf voelt, zodat je je weer fris kunt voelen.</li>
	//   </ul>

	//   <h3 class="text-xl font-semibold mt-6 mb-2">Hoe gebruik je Zolpidem?</h3>
	//   <p>Neem één tablet van <strong>Zolpidem 10mg</strong> vlak voor het slapengaan in, bij voorkeur met een glas water. Zorg ervoor dat je 7 tot 8 uur kunt slapen om het volledige effect van het medicijn te ervaren. Het is belangrijk om het geneesmiddel op een lege maag in te nemen, zodat het snel en effectief kan werken. Vermijd het eten van zware maaltijden kort voor het slapen, omdat dit de werking van het medicijn kan vertragen.</p>

	//   <h3 class="text-xl font-semibold mt-6 mb-2">Let op bij gebruik</h3>
	//   <ul class="list-disc pl-5">
	//     <li><strong>Niet combineren met alcohol:</strong> Zolpidem mag niet samen met alcohol of andere verdovende middelen worden gebruikt, omdat dit de werking versterkt en gevaarlijke bijwerkingen kan veroorzaken.</li>
	//     <li><strong>Niet gebruiken tijdens autorijden of werken met machines:</strong> Het is belangrijk om geen voertuigen te besturen of gevaarlijke machines te bedienen na het gebruik van Zolpidem, aangezien het je reactievermogen kan verminderen.</li>
	//     <li><strong>Gebruik alleen zoals voorgeschreven:</strong> Zolpidem is bedoeld voor kortdurend gebruik, meestal niet langer dan enkele weken. Het moet alleen worden gebruikt zoals voorgeschreven door je arts om afhankelijkheid of misbruik te voorkomen.</li>
	//     <li><strong>Raadpleeg je arts bij bijwerkingen:</strong> Als je last hebt van bijwerkingen zoals extreme slaperigheid, geheugenverlies of ongewone gedragingen zoals slaapwandelen, neem dan onmiddellijk contact op met je arts.</li>
	//   </ul>

	//   <h2 class="text-[32px] font-medium mb-4 mt-8">Zolpidem 10mg discreet online bestellen</h2>
	//   <p>Wil je Zolpidem 10mg veilig en discreet online kopen? Bij ons kun je eenvoudig en snel Zolpidem 10mg bestellen via een beveiligde en vertrouwde webshop. Wij zorgen voor een snelle levering en discrete verpakking, zodat je bestelling niemand zal opvallen. Wij bieden veilige betaalmethodes zoals iDEAL en bankoverschrijving, zodat je bestelling veilig en snel wordt verwerkt. Bestel nu en verbeter je nachtrust op een verantwoorde manier met <strong>Zolpidem 10mg</strong>.</p>

	//   <h3 class="text-xl font-semibold mt-6 mb-2">Waarom Zolpidem bij ons kopen?</h3>
	//   <p>Bij ons ben je verzekerd van de beste kwaliteit en betrouwbare service. Wij bieden Zolpidem 10mg tegen competitieve prijzen en bieden regelmatig kortingen bij grotere bestellingen. Of je nu eenmalig Zolpidem nodig hebt of het regelmatig gebruikt, wij zorgen ervoor dat je altijd snel en eenvoudig kunt bestellen. Kies voor veiligheid, betrouwbaarheid en een zorgeloze aankoopervaring.</p>
	// `,
	// 	},
	// added
	{
		id: 4,
		name: "Lorazepam 2.5mg",
		slug: "lorazepam-2.5mg-kopen",
		price: 70,
		originalPrice: 85,
		category: "Medicijnen",
		categories: ["Medicijnen"],
		stock: 120,
		image: "/images/products/lorazepam-2mg.jpg",
		shortDescription:
			"<strong>1 Doos Lorazepam 2,5 mg bevat 30 tabletten</strong>\n<ul>\n  <li>Behandeling van angststoornissen en stress</li>\n  <li>Verlicht symptomen van slapeloosheid door spanning</li>\n  <li>Helpt bij premedicatie voor tandheelkundige ingrepen</li>\n  <li>Werkt snel, meestal binnen 20-30 minuten</li>\n</ul>",

		description: `<h2 class="text-[32px] font-medium mb-4 mt-2">Lorazepam 2,5 mg – 30 tabletten</h2>
    <p class="mb-[14.4px]">Lorazepam 2,5 mg behoort tot de groep van benzodiazepinen en wordt veel gebruikt bij de behandeling van angststoornissen, stress, en slapeloosheid veroorzaakt door spanning. Het heeft kalmerende en spierontspannende eigenschappen, en werkt door op de neurotransmitters in de hersenen.</p>
  
    <h3 class="mt-4 mb-2 font-semibold text-lg">Toepassingen</h3>
    <ul class="list-decimal pl-10">
      <li>Behandeling van (ernstige) angststoornissen en stress</li>
      <li>Premedicatie bij operaties of tandheelkundige behandelingen</li>
      <li>Verlichting bij slapeloosheid veroorzaakt door spanning</li>
      <li>Ondersteuning bij alcoholontwenning en epileptische aanvallen</li>
    </ul>
  
    <h3 class="mt-4 mb-2 font-semibold text-lg">Werkingsduur</h3>
    <p>Lorazepam begint meestal binnen 20-30 minuten te werken en blijft 6 tot 8 uur actief, afhankelijk van persoonlijke factoren zoals stofwisseling en leeftijd.</p>
  
    <h3 class="mt-4 mb-2 font-semibold text-lg">Aanbevolen dosering</h3>
    <p>Voor angststoornissen: 1 tot 2,5 mg, 2 à 3 keer per dag. De dosering kan variëren op basis van medische adviezen. Langdurig gebruik kan leiden tot gewenning of afhankelijkheid.</p>
  
    <h3 class="mt-4 mb-2 font-semibold text-lg">Gebruik</h3>
    <p>Neem Lorazepam consequent in, met of zonder voedsel. Stop nooit abrupt met het gebruik zonder medisch advies van een arts.</p>
  
    <h3 class="mt-4 mb-2 font-semibold text-lg">Bijwerkingen</h3>
    <p>De meest voorkomende bijwerkingen zijn slaperigheid, duizeligheid, vermoeidheid, en verwardheid. Ouderen kunnen een verhoogd risico lopen op vallen.</p>
  
    <h3 class="mt-4 mb-2 font-semibold text-lg">Belangrijke voorzorgsmaatregelen</h3>
    <ul class="list-disc pl-10">
      <li>Kan verslavend zijn bij langdurig gebruik</li>
      <li>Vermijd alcohol en andere kalmerende middelen</li>
      <li>Niet autorijden of zware machines bedienen na inname</li>
      <li>Altijd geleidelijk afbouwen onder begeleiding van een arts</li>
    </ul>
  
    <h2 class="text-[32px] font-medium mb-4 mt-6">Lorazepam 2,5 mg online bestellen</h2>
    <p>Wil je Lorazepam 2,5 mg veilig en discreet online kopen? Bij ons ben je verzekerd van snelle levering, betrouwbare service en een gemakkelijke bestelprocedure via iDEAL.</p>
  
    <p>Profiteer van volumekortingen bij grotere bestellingen – ideaal voor zowel persoonlijke als zakelijke doeleinden. Onze klanten waarderen de discretie, gebruiksvriendelijkheid en kwaliteit van onze service.</p>
  
    <p>Naast Lorazepam bieden wij ook andere slaap- en kalmeringsmiddelen aan, zoals <strong>Temazepam</strong>. Vraag gerust naar ons volledige assortiment.</p>
  
    <p>Voor een betrouwbare en snelle levering van Lorazepam 2,5 mg, kies voor onze online apotheek.</p>`,

		updatedAt: new Date(),
	},
	// added
	{
		id: 5,
		name: "Alprazolam 1mg",
		slug: "alprazolam-1mg-kopen",
		price: 70,
		originalPrice: 85,
		category: "Medicijnen",
		categories: ["Medicijnen"],
		stock: 120,
		image: "/images/products/alprazolam-1mg.jpg",
		shortDescription:
			"<strong>1 Doosje Alprazolam 1mg bevat 30 tabletten</strong>\n<ul>\n  <li>Effectief in het verminderen van angst en paniekaanvallen</li>\n  <li>Werkt snel binnen een halfuur tot een uur</li>\n  <li>Effecten blijven enkele uren aan</li>\n  <li>Bijwerkingen kunnen slaperigheid en vermoeidheid zijn</li>\n</ul>",

		description: `<h2 class="text-[32px] font-medium mb-4 mt-2">Alprazolam 1mg – 30 Tabletten</h2>
    <p class="mb-[14.4px]">Alprazolam 1mg is een krachtig benzodiazepine dat vaak wordt voorgeschreven voor de behandeling van <strong>angststoornissen</strong> en <strong>paniekaanvallen</strong>. De 1mg-dosering is ideaal voor gecontroleerde verlichting van symptomen, altijd onder begeleiding van een arts.</p>
  
    <h3 class="text-xl font-semibold mt-4">Toepassingen</h3>
    <ul class="list-disc pl-6 mt-2">
      <li><strong>Angststoornissen:</strong> Vermindert gevoelens van nervositeit, spanning en angst.</li>
      <li><strong>Paniekaanvallen:</strong> Helpt bij het verlichten van symptomen van paniekstoornissen, met of zonder agorafobie.</li>
    </ul>
  
    <h3 class="text-xl font-semibold mt-4">Dosering en Gebruiksaanwijzing</h3>
    <p>Alprazolam werkt snel, meestal binnen 30 tot 60 minuten, en de effecten blijven enkele uren aan. De dosering kan per persoon variëren op basis van medische adviezen en klachten. Het is belangrijk de dosering geleidelijk af te bouwen om ontwenningsverschijnselen te voorkomen. Neem de tabletten met of zonder voedsel.</p>
  
    <h3 class="text-xl font-semibold mt-4">Bijwerkingen</h3>
    <p>De meest voorkomende bijwerkingen zijn slaperigheid, duizeligheid, vermoeidheid, geheugenproblemen en in sommige gevallen verwarring. Langdurig gebruik kan leiden tot gewenning of afhankelijkheid, dus overleg altijd met je arts bij langdurig gebruik.</p>
  
    <h2 class="text-[32px] font-medium mb-4 mt-6">Waarom Alprazolam 1mg bij ons kopen?</h2>
    <p>Zoek je een betrouwbare plek om <strong>Alprazolam 1mg</strong> te kopen? Wij bieden een gebruiksvriendelijke webshop met snelle levering, veilige betaalopties via iDEAL en scherpe prijzen, inclusief volumekortingen. Of je nu particulier of zakelijk bestelt, wij garanderen een professionele service en discreet verzonden pakketjes.</p>
  
    <p>Bij ons staat veiligheid, discretie en klanttevredenheid centraal. Profiteer van kortingen bij grotere bestellingen en bestel eenvoudig en veilig online zonder recept. Onze klantenservice is altijd beschikbaar om je te ondersteunen bij vragen of bestellingen.</p>`,

		updatedAt: new Date(),
	},
	{
		id: 12,
		name: "Zopiclone 7.5mg Tabletten",
		slug: "zopiclone-7.5mg-tabletten-kopen",
		price: 70,
		originalPrice: 85,
		category: "Medicijnen",
		categories: ["Medicijnen"],
		stock: 100,
		image: "/images/products/zopicionum-7mg.jpg",
		shortDescription:
			"Zopiclone kopen, 30 tabletten zopiclone 10mg, zopiclone doos medicijn slaappillen zopiclone",
		description: `
      <h2 class="text-[20px] font-medium my-4"><strong>Wat is Zopiclon?</strong></h2>
      <p>Zopiclon is een krachtig slaapmiddel dat sinds 1985 wordt voorgeschreven. Het staat bekend om zijn effectiviteit en veroorzaakt minder bijwerkingen dan klassieke benzodiazepinen. Hierdoor is Zopiclon een betrouwbare keuze voor mensen die kampen met slaapproblemen.</p>
    
      <h2 class="text-[20px] font-medium my-4"><strong>Waar wordt Zopiclon voor gebruikt?</strong></h2>
      <p>Zopiclon wordt gebruikt om de inslaaptijd te verkorten en de slaapduur te verlengen. Het is geschikt voor mensen met inslaapproblemen én voor mensen die 's nachts vaak wakker worden. De aanbevolen dosering is 7,5 mg, in te nemen circa 30 minuten voor het slapengaan.</p>
    
      <h2 class="text-[20px] font-medium my-4"><strong>Alternatieven voor Zopiclon</strong></h2>
      <p>Voor wie op zoek is naar alternatieven voor Zopiclon, zijn er andere behandelmogelijkheden die slaap kunnen bevorderen zonder gebruik van klassieke slaapmiddelen:</p>
      <ul class="list-disc pl-10 mb-4">
        <li><strong>Melatonine</strong>: Een lichaamseigen hormoon dat het slaap-waakritme helpt reguleren. Ideaal bij jetlag of een verstoord ritme.</li>
        <li><strong>Valeriaanwortel</strong>: Een natuurlijk kruid dat rustgevend werkt en al eeuwen wordt ingezet bij slapeloosheid en nervositeit.</li>
      </ul>
    
      <h2 class="text-[20px] font-medium my-4"><strong>Bijwerkingen van Zopiclon</strong></h2>
      <p>Zoals elk geneesmiddel kan ook Zopiclon bijwerkingen veroorzaken. Hieronder een overzicht van de meest gemelde klachten. Raadpleeg altijd de bijsluiter en neem bij twijfel contact op met uw arts of apotheker.</p>
    
      <h3 class="text-[24px] font-semibold mt-4">Vaak voorkomende bijwerkingen (meer dan 30 op de 100 mensen)</h3>
      <table class="w-full border border-stone-300 mt-3 text-sm">
        <thead>
          <tr>
            <th class="py-3 border-r border-b border-stone-300 bg-[#f9f9f9]">Bijwerking</th>
            <th class="py-3 border-b border-stone-300 bg-[#f9f9f9]">Beschrijving</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td class="py-2 border-r border-b border-stone-300 bg-[#F2F2F2] pl-4">Sufheid</td>
            <td class="py-2 border-b border-stone-300 bg-[#F2F2F2] pl-4">Komt vaak voor, vooral de ochtend na gebruik</td>
          </tr>
          <tr>
            <td class="py-2 border-r border-b border-stone-300 pl-4">Vermoeidheid</td>
            <td class="py-2 border-b border-stone-300 pl-4">Zeer zeldzaam gemeld</td>
          </tr>
          <tr>
            <td class="py-2 border-r border-b border-stone-300 bg-[#F2F2F2] pl-4">Duizeligheid</td>
            <td class="py-2 border-b border-stone-300 bg-[#F2F2F2] pl-4">Kan optreden bij te snelle dosering</td>
          </tr>
          <tr>
            <td class="py-2 border-r border-b border-stone-300 pl-4">Dubbel zien</td>
            <td class="py-2 border-b border-stone-300 pl-4">Vooral bij overdosering of gecombineerd gebruik met alcohol</td>
          </tr>
        </tbody>
      </table>
    
      <h2 class="text-[20px] font-medium my-4"><strong>Zeldzame bijwerkingen (1 tot 10 op de 100 mensen)</strong></h2>
      <table class="w-full border border-stone-300 mt-3 text-sm">
        <thead>
          <tr>
            <th class="py-3 border-r border-b border-stone-300 bg-[#f9f9f9]">Bijwerking</th>
            <th class="py-3 border-b border-stone-300 bg-[#f9f9f9]">Beschrijving</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td class="py-2 border-r border-b border-stone-300 bg-[#F2F2F2] pl-4">Bittere smaak</td>
            <td class="py-2 border-b border-stone-300 bg-[#F2F2F2] pl-4">Metaalachtige nasmaak in de mond</td>
          </tr>
          <tr>
            <td class="py-2 border-r border-b border-stone-300 pl-4">Droge mond</td>
            <td class="py-2 border-b border-stone-300 pl-4">Kan hinderlijk zijn bij langdurig gebruik</td>
          </tr>
          <tr>
            <td class="py-2 border-r border-b border-stone-300 pl-4">Gewenning</td>
            <td class="py-2 border-b border-stone-300 pl-4">Mogelijk bij langdurig dagelijks gebruik</td>
          </tr>
        </tbody>
      </table>
    
      <h2 class="text-[20px] font-medium my-4"><strong>Zeer zeldzame bijwerkingen (minder dan 1 op de 100 mensen)</strong></h2>
      <p class="mt-3">Ernstige bijwerkingen komen zelden voor. Neem bij twijfel of bij onverwachte symptomen altijd contact op met uw arts of apotheker.</p>
    
      <h2 class="text-[20px] font-medium my-4"><strong>Belangrijke informatie voor gebruik</strong></h2>
      <p>Gebruik Zopiclon uitsluitend zoals voorgeschreven. Na inname dient u direct te gaan slapen en geen taken meer te verrichten die alertheid vereisen, zoals autorijden of werken met machines.</p>
      <p class="mt-3">Zopiclon blijft een bewezen en betrouwbaar slaapmiddel voor mensen met slapeloosheid, dankzij de goede balans tussen effectiviteit en beperkte bijwerkingen.</p>
    `,
	},
];

// Get all products
export const getProducts = () => {
	return Promise.resolve(products);
};

// Get product by ID
export const getProductById = (id) => {
	console.log(id);
	const product = products.find(
		(p) => p.slug.toLowerCase().split(" ").join("-") === id
	);
	return Promise.resolve(product || null);
};

// Get products by category
export const getProductsByCategory = (category) => {
	const categoryProducts = products.filter(
		(p) =>
			p.category.toLowerCase() === category.toLowerCase() ||
			p.categories.some((c) => c.toLowerCase() === category.toLowerCase())
	);
	return Promise.resolve(categoryProducts);
};

// Get related products
export const getRelatedProducts = (category, currentProductId) => {
	const relatedProducts = products.filter(
		(p) =>
			(p.category === category || p.categories.includes(category)) &&
			p.id !== currentProductId
	);
	return Promise.resolve(relatedProducts.slice(0, 4));
};
