export const blogs = [
	{
		id: 1,
		url: "geenrecept-medicijnen-bestellen-europa",
		title:
			"Geenrecept: Veilig Medicijnen Bestellen in Heel Europa met iDEAL en Bancontact",
		shortTitle: "Medicijnen Bestellen in Europa - Geenrecept",
		category: "Medicijnen",
		author: "Dr. Sarah van der Berg",
		date: "15 Jun 2025",
		image: "/images/blog/geenrecept-medicijnen-bestellen-europa.jpg",
		content: `
      <div class="max-w-4xl mx-auto prose prose-lg">
        <h1 class="text-4xl font-bold text-gray-900 mb-6">Geenrecept: Uw Betrouwbare Partner voor Medicijnen in Heel Europa</h1>
        
        <div class="bg-gradient-to-r from-teal-50 to-blue-50 p-6 rounded-lg mb-8 border-l-4 border-teal-500">
          <p class="text-lg text-gray-700 leading-relaxed">
            <strong>Geenrecept</strong> is de toonaangevende online apotheek die medicijnen levert aan klanten door heel Europa. Met veilige betaalmethoden zoals <strong>iDEAL</strong> en <strong>Bancontact</strong> maken wij medicijnen toegankelijk voor iedereen.
          </p>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Waarom Kiezen voor Geenrecept?</h2>
        
        <div class="grid md:grid-cols-2 gap-6 mb-8">
          <div class="bg-white p-6 rounded-lg shadow-md border border-gray-200">
            <h3 class="text-xl font-semibold text-teal-600 mb-3">🌍 Europese Dekking</h3>
            <p class="text-gray-700">Geenrecept levert medicijnen naar alle Europese landen. Of u nu in Nederland, België, Duitsland, Frankrijk of elders in Europa woont - wij zorgen voor snelle en discrete levering.</p>
          </div>
          
          <div class="bg-white p-6 rounded-lg shadow-md border border-gray-200">
            <h3 class="text-xl font-semibold text-teal-600 mb-3">💳 Veilige Betalingen</h3>
            <p class="text-gray-700">Betaal veilig met iDEAL, Bancontact, creditcard of andere vertrouwde betaalmethoden. Alle transacties zijn 100% beveiligd met SSL-encryptie.</p>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Betaalmethoden bij Geenrecept</h2>
        
        <div class="bg-gray-50 p-6 rounded-lg mb-8">
          <h3 class="text-2xl font-semibold text-gray-800 mb-4">Ondersteunde Betaalmethoden:</h3>
          
          <div class="grid md:grid-cols-3 gap-4 mb-6">
            <div class="bg-white p-4 rounded-lg shadow-sm border">
              <h4 class="font-semibold text-blue-600 mb-2">🇳🇱 iDEAL</h4>
              <p class="text-sm text-gray-600">De meest populaire betaalmethode in Nederland. Direct en veilig betalen via uw eigen bank.</p>
            </div>
            
            <div class="bg-white p-4 rounded-lg shadow-sm border">
              <h4 class="font-semibold text-purple-600 mb-2">🇧🇪 Bancontact</h4>
              <p class="text-sm text-gray-600">De standaard betaalmethode in België. Veilig betalen met uw Belgische bankkaart.</p>
            </div>
            
            <div class="bg-white p-4 rounded-lg shadow-sm border">
              <h4 class="font-semibold text-green-600 mb-2">💳 Creditcard</h4>
              <p class="text-sm text-gray-600">Visa, Mastercard en American Express worden geaccepteerd voor internationale klanten.</p>
            </div>
          </div>
          
          <p class="text-gray-700 italic">
            <strong>Geenrecept</strong> gebruikt de nieuwste beveiligingstechnologieën om uw betalingsgegevens te beschermen. Alle transacties worden versleuteld en veilig verwerkt.
          </p>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Medicijnen Bestellen in Europa</h2>
        
        <div class="space-y-6 mb-8">
          <div class="border-l-4 border-teal-500 pl-6">
            <h3 class="text-xl font-semibold text-gray-800 mb-2">Stap 1: Selecteer uw medicijnen</h3>
            <p class="text-gray-700">Browse door ons uitgebreide assortiment medicijnen. Geenrecept biedt een breed scala aan geneesmiddelen voor verschillende aandoeningen.</p>
          </div>
          
          <div class="border-l-4 border-blue-500 pl-6">
            <h3 class="text-xl font-semibold text-gray-800 mb-2">Stap 2: Veilig afrekenen</h3>
            <p class="text-gray-700">Kies uw gewenste betaalmethode: iDEAL voor Nederlandse klanten, Bancontact voor Belgische klanten, of creditcard voor andere Europese landen.</p>
          </div>
          
          <div class="border-l-4 border-green-500 pl-6">
            <h3 class="text-xl font-semibold text-gray-800 mb-2">Stap 3: Discrete levering</h3>
            <p class="text-gray-700">Uw bestelling wordt discreet verpakt en snel verzonden naar uw adres in Europa. Tracking informatie wordt automatisch verstrekt.</p>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Voordelen van Geenrecept</h2>
        
        <div class="bg-gradient-to-br from-teal-50 to-blue-50 p-8 rounded-xl mb-8">
          <div class="grid md:grid-cols-2 gap-6">
            <div>
              <h3 class="text-lg font-semibold text-teal-700 mb-3">✅ Kwaliteitsgarantie</h3>
              <p class="text-gray-700 mb-4">Alle medicijnen bij Geenrecept zijn van farmaceutische kwaliteit en voldoen aan Europese standaarden.</p>
              
              <h3 class="text-lg font-semibold text-teal-700 mb-3">🚚 Snelle Levering</h3>
              <p class="text-gray-700 mb-4">Levering binnen 2-5 werkdagen in heel Europa. Express verzending beschikbaar voor urgente bestellingen.</p>
            </div>
            
            <div>
              <h3 class="text-lg font-semibold text-teal-700 mb-3">🔒 Privacy & Discretie</h3>
              <p class="text-gray-700 mb-4">Uw privacy is belangrijk. Alle bestellingen worden discreet verpakt zonder herkenbare labels.</p>
              
              <h3 class="text-lg font-semibold text-teal-700 mb-3">💬 24/7 Klantenservice</h3>
              <p class="text-gray-700">Onze klantenservice staat 24/7 voor u klaar via chat, email of telefoon.</p>
            </div>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Europese Landen waar Geenrecept Levert</h2>
        
        <div class="bg-white p-6 rounded-lg shadow-md border mb-8">
          <div class="grid md:grid-cols-4 gap-4 text-sm">
            <div>
              <h4 class="font-semibold text-gray-800 mb-2">West-Europa</h4>
              <ul class="space-y-1 text-gray-600">
                <li>🇳🇱 Nederland</li>
                <li>🇧🇪 België</li>
                <li>🇩🇪 Duitsland</li>
                <li>🇫🇷 Frankrijk</li>
                <li>🇱🇺 Luxemburg</li>
              </ul>
            </div>
            
            <div>
              <h4 class="font-semibold text-gray-800 mb-2">Noord-Europa</h4>
              <ul class="space-y-1 text-gray-600">
                <li>🇩🇰 Denemarken</li>
                <li>🇸🇪 Zweden</li>
                <li>🇳🇴 Noorwegen</li>
                <li>🇫🇮 Finland</li>
              </ul>
            </div>
            
            <div>
              <h4 class="font-semibold text-gray-800 mb-2">Zuid-Europa</h4>
              <ul class="space-y-1 text-gray-600">
                <li>🇪🇸 Spanje</li>
                <li>🇮🇹 Italië</li>
                <li>🇵🇹 Portugal</li>
                <li>🇬🇷 Griekenland</li>
              </ul>
            </div>
            
            <div>
              <h4 class="font-semibold text-gray-800 mb-2">Oost-Europa</h4>
              <ul class="space-y-1 text-gray-600">
                <li>🇵🇱 Polen</li>
                <li>🇨🇿 Tsjechië</li>
                <li>🇭🇺 Hongarije</li>
                <li>🇦🇹 Oostenrijk</li>
              </ul>
            </div>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Veiligheid en Betrouwbaarheid</h2>
        
        <div class="bg-red-50 border border-red-200 p-6 rounded-lg mb-8">
          <h3 class="text-xl font-semibold text-red-800 mb-3">⚠️ Belangrijke Veiligheidsinformatie</h3>
          <ul class="space-y-2 text-red-700">
            <li>• Raadpleeg altijd een arts voordat u medicijnen gebruikt</li>
            <li>• Lees de bijsluiter zorgvuldig door</li>
            <li>• Gebruik medicijnen alleen volgens voorschrift</li>
            <li>• Bewaar medicijnen op een veilige plaats, buiten bereik van kinderen</li>
          </ul>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Veelgestelde Vragen over Geenrecept</h2>
        
        <div class="space-y-4 mb-8">
          <div class="bg-gray-50 p-4 rounded-lg">
            <h3 class="font-semibold text-gray-800 mb-2">Is het veilig om medicijnen online te bestellen bij Geenrecept?</h3>
            <p class="text-gray-700">Ja, Geenrecept is een betrouwbare online apotheek die voldoet aan alle Europese regelgeving. Alle medicijnen zijn van farmaceutische kwaliteit.</p>
          </div>
          
          <div class="bg-gray-50 p-4 rounded-lg">
            <h3 class="font-semibold text-gray-800 mb-2">Welke betaalmethoden accepteert Geenrecept?</h3>
            <p class="text-gray-700">Geenrecept accepteert iDEAL, Bancontact, creditcards (Visa, Mastercard, American Express), bankoverschrijving en andere lokale betaalmethoden.</p>
          </div>
          
          <div class="bg-gray-50 p-4 rounded-lg">
            <h3 class="font-semibold text-gray-800 mb-2">Hoe lang duurt de levering in Europa?</h3>
            <p class="text-gray-700">Standaard levering duurt 2-5 werkdagen binnen Europa. Express verzending is beschikbaar voor urgente bestellingen.</p>
          </div>
        </div>

        <div class="bg-gradient-to-r from-teal-500 to-blue-600 text-white p-8 rounded-xl text-center mb-8">
          <h2 class="text-2xl font-bold mb-4">Klaar om te Bestellen bij Geenrecept?</h2>
          <p class="text-lg mb-6">Ontdek ons uitgebreide assortiment medicijnen en ervaar de voordelen van veilig online bestellen met iDEAL en Bancontact.</p>
          <a href="/shop" class="inline-block bg-white text-teal-600 px-8 py-3 rounded-full font-semibold hover:bg-gray-100 transition-colors">
            Bekijk Ons Assortiment
          </a>
        </div>

        <div class="text-center text-gray-600 text-sm">
          <p>Dit artikel is geschreven voor informatieve doeleinden. Raadpleeg altijd een arts voor medisch advies.</p>
          <p class="mt-2"><strong>Geenrecept</strong> - Uw betrouwbare partner voor medicijnen in heel Europa</p>
        </div>
      </div>
    `,
	},
	{
		id: 2,
		url: "ideal-bancontact-betalen-medicijnen-online",
		title:
			"Veilig Betalen met iDEAL en Bancontact bij Online Medicijnen Bestellen",
		shortTitle: "Veilig Betalen met iDEAL en Bancontact",
		category: "Betalingen",
		author: "Mark Janssen",
		date: "12 Mart 2025",
		image: "/images/blog/ideal-bancontact-betalen-medicijnen-online.png",
		content: `
      <div class="max-w-4xl mx-auto prose prose-lg">
        <h1 class="text-4xl font-bold text-gray-900 mb-6">Veilig Betalen met iDEAL en Bancontact voor Online Medicijnen</h1>
        
        <div class="bg-blue-50 p-6 rounded-lg mb-8 border-l-4 border-blue-500">
          <p class="text-lg text-gray-700 leading-relaxed">
            Het online bestellen van medicijnen wordt steeds populairder in Europa. <strong>iDEAL</strong> en <strong>Bancontact</strong> zijn de meest vertrouwde betaalmethoden voor Nederlandse en Belgische klanten bij <strong>Geenrecept</strong>.
          </p>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Waarom iDEAL en Bancontact?</h2>
        
        <div class="grid md:grid-cols-2 gap-8 mb-8">
          <div class="bg-orange-50 p-6 rounded-lg border border-orange-200">
            <h3 class="text-2xl font-semibold text-orange-700 mb-4">🇳🇱 iDEAL - Nederland</h3>
            <ul class="space-y-3 text-gray-700">
              <li class="flex items-start">
                <span class="text-green-500 mr-2">✓</span>
                <span>Direct betalen via uw eigen Nederlandse bank</span>
              </li>
              <li class="flex items-start">
                <span class="text-green-500 mr-2">✓</span>
                <span>Geen creditcard nodig</span>
              </li>
              <li class="flex items-start">
                <span class="text-green-500 mr-2">✓</span>
                <span>100% veilig en betrouwbaar</span>
              </li>
              <li class="flex items-start">
                <span class="text-green-500 mr-2">✓</span>
                <span>Onmiddellijke bevestiging</span>
              </li>
            </ul>
          </div>
          
          <div class="bg-purple-50 p-6 rounded-lg border border-purple-200">
            <h3 class="text-2xl font-semibold text-purple-700 mb-4">🇧🇪 Bancontact - België</h3>
            <ul class="space-y-3 text-gray-700">
              <li class="flex items-start">
                <span class="text-green-500 mr-2">✓</span>
                <span>Standaard betaalmethode in België</span>
              </li>
              <li class="flex items-start">
                <span class="text-green-500 mr-2">✓</span>
                <span>Betalen met uw Belgische bankkaart</span>
              </li>
              <li class="flex items-start">
                <span class="text-green-500 mr-2">✓</span>
                <span>Hoge beveiliging en privacy</span>
              </li>
              <li class="flex items-start">
                <span class="text-green-500 mr-2">✓</span>
                <span>Snelle transactieverwerking</span>
              </li>
            </ul>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Hoe Werkt Betalen bij Geenrecept?</h2>
        
        <div class="space-y-6 mb-8">
          <div class="bg-white p-6 rounded-lg shadow-md border-l-4 border-teal-500">
            <h3 class="text-xl font-semibold text-teal-700 mb-3">Stap 1: Selecteer uw medicijnen</h3>
            <p class="text-gray-700">Voeg de gewenste medicijnen toe aan uw winkelwagen op Geenrecept.com. Controleer de hoeveelheden en dosering.</p>
          </div>
          
          <div class="bg-white p-6 rounded-lg shadow-md border-l-4 border-blue-500">
            <h3 class="text-xl font-semibold text-blue-700 mb-3">Stap 2: Ga naar de kassa</h3>
            <p class="text-gray-700">Klik op 'Afrekenen' en vul uw verzendgegevens in. Kies uw gewenste leveringsoptie.</p>
          </div>
          
          <div class="bg-white p-6 rounded-lg shadow-md border-l-4 border-green-500">
            <h3 class="text-xl font-semibold text-green-700 mb-3">Stap 3: Kies uw betaalmethode</h3>
            <p class="text-gray-700">Selecteer iDEAL (Nederland) of Bancontact (België) als uw gewenste betaalmethode.</p>
          </div>
          
          <div class="bg-white p-6 rounded-lg shadow-md border-l-4 border-purple-500">
            <h3 class="text-xl font-semibold text-purple-700 mb-3">Stap 4: Voltooi de betaling</h3>
            <p class="text-gray-700">U wordt doorgeleid naar uw bank om de betaling veilig af te ronden. Na bevestiging ontvangt u direct een orderbevestiging.</p>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Beveiliging en Privacy</h2>
        
        <div class="bg-gray-50 p-8 rounded-xl mb-8">
          <h3 class="text-2xl font-semibold text-gray-800 mb-6 text-center">🔒 Uw Veiligheid is Onze Prioriteit</h3>
          
          <div class="grid md:grid-cols-3 gap-6">
            <div class="text-center">
              <div class="bg-green-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <span class="text-2xl">🛡️</span>
              </div>
              <h4 class="font-semibold text-gray-800 mb-2">SSL Encryptie</h4>
              <p class="text-sm text-gray-600">Alle gegevens worden versleuteld verzonden met 256-bit SSL encryptie.</p>
            </div>
            
            <div class="text-center">
              <div class="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <span class="text-2xl">🏦</span>
              </div>
              <h4 class="font-semibold text-gray-800 mb-2">Bankbeveiliging</h4>
              <p class="text-sm text-gray-600">iDEAL en Bancontact gebruiken de beveiliging van uw eigen bank.</p>
            </div>
            
            <div class="text-center">
              <div class="bg-purple-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                <span class="text-2xl">🔐</span>
              </div>
              <h4 class="font-semibold text-gray-800 mb-2">Privacy Bescherming</h4>
              <p class="text-sm text-gray-600">Uw betalingsgegevens worden nooit opgeslagen op onze servers.</p>
            </div>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Andere Betaalmethoden bij Geenrecept</h2>
        
        <div class="bg-white p-6 rounded-lg shadow-md border mb-8">
          <div class="grid md:grid-cols-2 gap-6">
            <div>
              <h3 class="text-lg font-semibold text-gray-800 mb-3">Voor Nederlandse Klanten:</h3>
              <ul class="space-y-2 text-gray-700">
                <li>• iDEAL (aanbevolen)</li>
                <li>• Creditcard (Visa, Mastercard)</li>
                <li>• Bankoverschrijving</li>
                <li>• PayPal</li>
              </ul>
            </div>
            
            <div>
              <h3 class="text-lg font-semibold text-gray-800 mb-3">Voor Belgische Klanten:</h3>
              <ul class="space-y-2 text-gray-700">
                <li>• Bancontact (aanbevolen)</li>
                <li>• Creditcard (Visa, Mastercard)</li>
                <li>• Bankoverschrijving</li>
                <li>• PayPal</li>
              </ul>
            </div>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Tips voor Veilig Online Betalen</h2>
        
        <div class="bg-yellow-50 border border-yellow-200 p-6 rounded-lg mb-8">
          <h3 class="text-xl font-semibold text-yellow-800 mb-4">💡 Veiligheidstips</h3>
          <ul class="space-y-3 text-yellow-700">
            <li class="flex items-start">
              <span class="text-yellow-600 mr-2">•</span>
              <span>Controleer altijd of de website begint met 'https://' en het slotje-icoon zichtbaar is</span>
            </li>
            <li class="flex items-start">
              <span class="text-yellow-600 mr-2">•</span>
              <span>Gebruik alleen vertrouwde betaalmethoden zoals iDEAL en Bancontact</span>
            </li>
            <li class="flex items-start">
              <span class="text-yellow-600 mr-2">•</span>
              <span>Bewaar altijd uw orderbevestiging en betalingsbewijzen</span>
            </li>
            <li class="flex items-start">
              <span class="text-yellow-600 mr-2">•</span>
              <span>Betaal nooit via onveilige verbindingen of openbare WiFi</span>
            </li>
          </ul>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Voordelen van Geenrecept</h2>
        
        <div class="grid md:grid-cols-2 gap-6 mb-8">
          <div class="bg-teal-50 p-6 rounded-lg border border-teal-200">
            <h3 class="text-xl font-semibold text-teal-700 mb-3">Snelle Verwerking</h3>
            <p class="text-gray-700">Betalingen via iDEAL en Bancontact worden direct verwerkt, zodat uw bestelling snel kan worden verzonden.</p>
          </div>
          
          <div class="bg-blue-50 p-6 rounded-lg border border-blue-200">
            <h3 class="text-xl font-semibold text-blue-700 mb-3">Europese Levering</h3>
            <p class="text-gray-700">Geenrecept levert naar alle Europese landen met discrete verpakking en tracking.</p>
          </div>
          
          <div class="bg-green-50 p-6 rounded-lg border border-green-200">
            <h3 class="text-xl font-semibold text-green-700 mb-3">24/7 Support</h3>
            <p class="text-gray-700">Onze klantenservice helpt u bij vragen over betalingen of bestellingen, 24 uur per dag.</p>
          </div>
          
          <div class="bg-purple-50 p-6 rounded-lg border border-purple-200">
            <h3 class="text-xl font-semibold text-purple-700 mb-3">Kwaliteitsgarantie</h3>
            <p class="text-gray-700">Alle medicijnen voldoen aan Europese kwaliteitsnormen en worden discreet geleverd.</p>
          </div>
        </div>

        <div class="bg-gradient-to-r from-blue-500 to-purple-600 text-white p-8 rounded-xl text-center mb-8">
          <h2 class="text-2xl font-bold mb-4">Klaar om Veilig te Betalen?</h2>
          <p class="text-lg mb-6">Ervaar de voordelen van veilig betalen met iDEAL en Bancontact bij Geenrecept.</p>
          <a href="/shop" class="inline-block bg-white text-blue-600 px-8 py-3 rounded-full font-semibold hover:bg-gray-100 transition-colors">
            Start met Bestellen
          </a>
        </div>

        <div class="text-center text-gray-600 text-sm">
          <p><strong>Geenrecept</strong> - Veilig, betrouwbaar en discreet medicijnen bestellen in heel Europa</p>
        </div>
      </div>
    `,
	},
	{
		id: 3,
		url: "europa-medicijnen-levering-geenrecept",
		title:
			"Medicijnen Levering in Heel Europa - Geenrecept Internationale Service",
		shortTitle: "Europese Medicijnen Levering",
		category: "Levering",
		author: "Dr. Emma Kowalski",
		date: "10 Februari 2025",
		image: "/images/blog/europa-medicijnen-levering-geenrecept.jpg",
		content: `
      <div class="max-w-4xl mx-auto prose prose-lg">
        <h1 class="text-4xl font-bold text-gray-900 mb-6">Medicijnen Levering in Heel Europa met Geenrecept</h1>
        
        <div class="bg-green-50 p-6 rounded-lg mb-8 border-l-4 border-green-500">
          <p class="text-lg text-gray-700 leading-relaxed">
            <strong>Geenrecept</strong> is uw betrouwbare partner voor medicijnen levering in heel Europa. Met veilige betaalmethoden zoals <strong>iDEAL</strong> en <strong>Bancontact</strong> maken wij hoogwaardige medicijnen toegankelijk voor klanten in alle Europese landen.
          </p>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Europese Dekking van Geenrecept</h2>
        
        <div class="bg-white p-8 rounded-lg shadow-md border mb-8">
          <h3 class="text-2xl font-semibold text-center text-gray-800 mb-6">🌍 Landen waar Geenrecept Levert</h3>
          
          <div class="grid md:grid-cols-4 gap-6">
            <div class="text-center">
              <h4 class="font-semibold text-blue-600 mb-3">West-Europa</h4>
              <ul class="space-y-2 text-sm text-gray-700">
                <li>🇳🇱 Nederland</li>
                <li>🇧🇪 België</li>
                <li>🇩🇪 Duitsland</li>
                <li>🇫🇷 Frankrijk</li>
                <li>🇱🇺 Luxemburg</li>
                <li>🇨🇭 Zwitserland</li>
                <li>🇦🇹 Oostenrijk</li>
              </ul>
            </div>
            
            <div class="text-center">
              <h4 class="font-semibold text-green-600 mb-3">Noord-Europa</h4>
              <ul class="space-y-2 text-sm text-gray-700">
                <li>🇸🇪 Zweden</li>
                <li>🇳🇴 Noorwegen</li>
                <li>🇩🇰 Denemarken</li>
                <li>🇫🇮 Finland</li>
                <li>🇮🇸 IJsland</li>
              </ul>
            </div>
            
            <div class="text-center">
              <h4 class="font-semibold text-orange-600 mb-3">Zuid-Europa</h4>
              <ul class="space-y-2 text-sm text-gray-700">
                <li>🇪🇸 Spanje</li>
                <li>🇮🇹 Italië</li>
                <li>🇵🇹 Portugal</li>
                <li>🇬🇷 Griekenland</li>
                <li>🇲🇹 Malta</li>
                <li>🇨🇾 Cyprus</li>
              </ul>
            </div>
            
            <div class="text-center">
              <h4 class="font-semibold text-purple-600 mb-3">Oost-Europa</h4>
              <ul class="space-y-2 text-sm text-gray-700">
                <li>🇵🇱 Polen</li>
                <li>🇨🇿 Tsjechië</li>
                <li>🇭🇺 Hongarije</li>
                <li>🇸🇰 Slowakije</li>
                <li>🇸🇮 Slovenië</li>
                <li>🇪🇪 Estland</li>
                <li>🇱🇻 Letland</li>
                <li>🇱🇹 Litouwen</li>
              </ul>
            </div>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Leveringstijden per Regio</h2>
        
        <div class="grid md:grid-cols-2 gap-6 mb-8">
          <div class="bg-blue-50 p-6 rounded-lg border border-blue-200">
            <h3 class="text-xl font-semibold text-blue-700 mb-4">🚚 Standaard Levering</h3>
            <ul class="space-y-3 text-gray-700">
              <li><strong>Nederland & België:</strong> 1-2 werkdagen</li>
              <li><strong>Duitsland & Frankrijk:</strong> 2-3 werkdagen</li>
              <li><strong>Overige EU-landen:</strong> 3-5 werkdagen</li>
              <li><strong>Scandinavië:</strong> 4-6 werkdagen</li>
            </ul>
          </div>
          
          <div class="bg-green-50 p-6 rounded-lg border border-green-200">
            <h3 class="text-xl font-semibold text-green-700 mb-4">⚡ Express Levering</h3>
            <ul class="space-y-3 text-gray-700">
              <li><strong>Nederland & België:</strong> Volgende werkdag</li>
              <li><strong>Duitsland & Frankrijk:</strong> 1-2 werkdagen</li>
              <li><strong>Overige EU-landen:</strong> 2-3 werkdagen</li>
              <li><strong>Scandinavië:</strong> 2-4 werkdagen</li>
            </ul>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Betaalmethoden per Land</h2>
        
        <div class="bg-gray-50 p-8 rounded-xl mb-8">
          <h3 class="text-2xl font-semibold text-center text-gray-800 mb-6">💳 Lokale Betaalmethoden</h3>
          
          <div class="grid md:grid-cols-3 gap-6">
            <div class="bg-white p-4 rounded-lg shadow-sm">
              <h4 class="font-semibold text-orange-600 mb-3">🇳🇱 Nederland</h4>
              <ul class="text-sm text-gray-700 space-y-1">
                <li>• iDEAL (meest populair)</li>
                <li>• Creditcard</li>
                <li>• PayPal</li>
                <li>• Bankoverschrijving</li>
              </ul>
            </div>
            
            <div class="bg-white p-4 rounded-lg shadow-sm">
              <h4 class="font-semibold text-purple-600 mb-3">🇧🇪 België</h4>
              <ul class="text-sm text-gray-700 space-y-1">
                <li>• Bancontact (aanbevolen)</li>
                <li>• Creditcard</li>
                <li>• PayPal</li>
                <li>• Bankoverschrijving</li>
              </ul>
            </div>
            
            <div class="bg-white p-4 rounded-lg shadow-sm">
              <h4 class="font-semibold text-blue-600 mb-3">🇪🇺 Overige EU</h4>
              <ul class="text-sm text-gray-700 space-y-1">
                <li>• Creditcard (Visa, MC)</li>
                <li>• PayPal</li>
                <li>• SEPA bankoverschrijving</li>
                <li>• Lokale methoden</li>
              </ul>
            </div>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Discrete en Veilige Verpakking</h2>
        
        <div class="space-y-6 mb-8">
          <div class="bg-white p-6 rounded-lg shadow-md border-l-4 border-teal-500">
            <h3 class="text-xl font-semibold text-teal-700 mb-3">📦 Discrete Verpakking</h3>
            <p class="text-gray-700">Alle bestellingen van Geenrecept worden discreet verpakt zonder herkenbare labels of logo's. Uw privacy is gegarandeerd.</p>
          </div>
          
          <div class="bg-white p-6 rounded-lg shadow-md border-l-4 border-blue-500">
            <h3 class="text-xl font-semibold text-blue-700 mb-3">🛡️ Veilige Verpakking</h3>
            <p class="text-gray-700">Medicijnen worden verpakt in temperatuurbestendige verpakkingen om de kwaliteit tijdens transport te waarborgen.</p>
          </div>
          
          <div class="bg-white p-6 rounded-lg shadow-md border-l-4 border-green-500">
            <h3 class="text-xl font-semibold text-green-700 mb-3">📍 Track & Trace</h3>
            <p class="text-gray-700">Elke bestelling krijgt een unieke trackingcode waarmee u uw pakket kunt volgen van verzending tot levering.</p>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Verzendkosten Europa</h2>
        
        <div class="bg-white p-6 rounded-lg shadow-md border mb-8">
          <div class="overflow-x-auto">
            <table class="w-full text-sm">
              <thead>
                <tr class="bg-gray-100">
                  <th class="text-left p-3 font-semibold">Regio</th>
                  <th class="text-left p-3 font-semibold">Standaard</th>
                  <th class="text-left p-3 font-semibold">Express</th>
                  <th class="text-left p-3 font-semibold">Gratis vanaf</th>
                </tr>
              </thead>
              <tbody>
                <tr class="border-b">
                  <td class="p-3">Nederland & België</td>
                  <td class="p-3">€4.95</td>
                  <td class="p-3">€9.95</td>
                  <td class="p-3">€50</td>
                </tr>
                <tr class="border-b">
                  <td class="p-3">Duitsland & Frankrijk</td>
                  <td class="p-3">€7.95</td>
                  <td class="p-3">€14.95</td>
                  <td class="p-3">€75</td>
                </tr>
                <tr class="border-b">
                  <td class="p-3">Overige EU-landen</td>
                  <td class="p-3">€9.95</td>
                  <td class="p-3">€19.95</td>
                  <td class="p-3">€100</td>
                </tr>
                <tr>
                  <td class="p-3">Scandinavië</td>
                  <td class="p-3">€12.95</td>
                  <td class="p-3">€24.95</td>
                  <td class="p-3">€125</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Klantenservice in Heel Europa</h2>
        
        <div class="bg-gradient-to-br from-blue-50 to-purple-50 p-8 rounded-xl mb-8">
          <h3 class="text-2xl font-semibold text-center text-gray-800 mb-6">🌍 Meertalige Support</h3>
          
          <div class="grid md:grid-cols-2 gap-6">
            <div>
              <h4 class="font-semibold text-blue-600 mb-3">Beschikbare Talen:</h4>
              <ul class="space-y-2 text-gray-700">
                <li>🇳🇱 Nederlands</li>
                <li>🇬🇧 Engels</li>
                <li>🇩🇪 Duits</li>
                <li>🇫🇷 Frans</li>
                <li>🇪🇸 Spaans</li>
                <li>🇮🇹 Italiaans</li>
              </ul>
            </div>
            
            <div>
              <h4 class="font-semibold text-purple-600 mb-3">Contact Opties:</h4>
              <ul class="space-y-2 text-gray-700">
                <li>📧 Email: 24/7 beschikbaar</li>
                <li>💬 Live Chat: 9:00-21:00</li>
                <li>📞 Telefoon: Werkdagen</li>
                <li>📱 WhatsApp: Snel contact</li>
              </ul>
            </div>
          </div>
        </div>

        <h2 class="text-3xl font-semibold text-gray-800 mt-8 mb-4">Waarom Kiezen voor Geenrecept?</h2>
        
        <div class="grid md:grid-cols-2 gap-6 mb-8">
          <div class="bg-teal-50 p-6 rounded-lg border border-teal-200">
            <h3 class="text-xl font-semibold text-teal-700 mb-3">✅ Europese Kwaliteit</h3>
            <p class="text-gray-700">Alle medicijnen voldoen aan strenge Europese kwaliteitsnormen en zijn geregistreerd bij de relevante autoriteiten.</p>
          </div>
          
          <div class="bg-blue-50 p-6 rounded-lg border border-blue-200">
            <h3 class="text-xl font-semibold text-blue-700 mb-3">🚀 Snelle Levering</h3>
            <p class="text-gray-700">Met onze strategische locaties in Europa zorgen we voor snelle levering naar alle EU-landen.</p>
          </div>
          
          <div class="bg-green-50 p-6 rounded-lg border border-green-200">
            <h3 class="text-xl font-semibold text-green-700 mb-3">🔒 Veilige Betaling</h3>
            <p class="text-gray-700">Betaal veilig met iDEAL, Bancontact of andere vertrouwde lokale betaalmethoden.</p>
          </div>
          
          <div class="bg-purple-50 p-6 rounded-lg border border-purple-200">
            <h3 class="text-xl font-semibold text-purple-700 mb-3">🤝 Betrouwbare Service</h3>
            <p class="text-gray-700">Meer dan 10 jaar ervaring in het leveren van medicijnen aan klanten in heel Europa.</p>
          </div>
        </div>

        <div class="bg-red-50 border border-red-200 p-6 rounded-lg mb-8">
          <h3 class="text-xl font-semibold text-red-800 mb-3">⚠️ Belangrijke Informatie</h3>
          <ul class="space-y-2 text-red-700">
            <li>• Raadpleeg altijd een arts voordat u medicijnen gebruikt</li>
            <li>• Controleer de lokale regelgeving in uw land</li>
            <li>• Bewaar medicijnen op een koele, droge plaats</li>
            <li>• Lees altijd de bijsluiter zorgvuldig door</li>
          </ul>
        </div>

        <div class="bg-gradient-to-r from-teal-500 to-blue-600 text-white p-8 rounded-xl text-center mb-8">
          <h2 class="text-2xl font-bold mb-4">Klaar om te Bestellen?</h2>
          <p class="text-lg mb-6">Ontdek waarom duizenden Europeanen vertrouwen op Geenrecept voor hun medicijnen.</p>
          <a href="/shop" class="inline-block bg-white text-teal-600 px-8 py-3 rounded-full font-semibold hover:bg-gray-100 transition-colors">
            Bekijk Ons Assortiment
          </a>
        </div>

        <div class="text-center text-gray-600 text-sm">
          <p><strong>Geenrecept</strong> - Uw vertrouwde partner voor medicijnen in heel Europa</p>
          <p class="mt-2">Veilig bestellen • Discrete levering • Europese kwaliteit</p>
        </div>
      </div>
    `,
	},
];

export const getBlogDataById = (url) => {
	//   console.log(id);
	const product = blogs.find((b) => b.url === url);
	return Promise.resolve(product || null);
};

export const getBlogsByCategory = (category) => {
	console.log(category);
	if (!category || category === "Alle categorieën") {
		return Promise.resolve(blogs);
	}
	const filteredBlogs = blogs.filter(
		(blog) => blog.category.toLowerCase() === category.toLowerCase()
	);
	return Promise.resolve(filteredBlogs);
};

export const getRelatedArticle = (category, displayId) => {
	//   if (!category || !displayId) {
	//     return Promise.resolve();
	//   }
	//   const filter = blogs.filter((blog) => blog.category === category);
	//   const relatedArticle = filter.filter((i) => i.is !== parseFloat(displayId));
	//   return Promise.resolve(relatedArticle);
};
