"use client"

import { useState } from "react"

export default function NewsletterSection() {
	const [email, setEmail] = useState("")
	const [isSubmitted, setIsSubmitted] = useState(false)
	const [isLoading, setIsLoading] = useState(false)

	const handleSubmit = (e) => {
		e.preventDefault()
		setIsLoading(true)

		// Simuleer een API call
		setTimeout(() => {
			setIsLoading(false)
			setIsSubmitted(true)
			setEmail("")
		}, 1500)
	}

	return (
		<section className="py-16 px-4 md:px-8 bg-white">
			<div className="max-w-5xl mx-auto bg-gradient-to-r from-blue-600 to-purple-600 rounded-2xl overflow-hidden shadow-xl">
				<div className="p-8 md:p-12 flex flex-col md:flex-row items-center">
					<div className="md:w-1/2 mb-8 md:mb-0 md:pr-8">
						<h2 className="text-3xl font-bold text-white mb-4">Blijf op de hoogte</h2>
						<p className="text-blue-100 mb-6">
							Schrijf je in voor onze nieuwsbrief en ontvang exclusieve aanbiedingen, gezondheidsnieuws en updates over
							nieuwe producten.
						</p>

						{isSubmitted ? (
							<div className="bg-white/20 backdrop-blur-sm rounded-lg p-4 text-white">
								<div className="flex items-center">
									<svg
										xmlns="http://www.w3.org/2000/svg"
										className="h-6 w-6 mr-2 text-green-300"
										fill="none"
										viewBox="0 0 24 24"
										stroke="currentColor"
									>
										<path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
									</svg>
									<p>Bedankt voor je inschrijving! Je ontvangt binnenkort onze nieuwsbrief.</p>
								</div>
							</div>
						) : (
							<form onSubmit={handleSubmit} className="w-full">
								<div className="flex flex-col sm:flex-row gap-3">
									<input
										type="email"
										value={email}
										onChange={(e) => setEmail(e.target.value)}
										placeholder="Jouw e-mailadres"
										required
										className="flex-1 px-4 py-3 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-300"
									/>
									<button
										type="submit"
										disabled={isLoading}
										className="px-6 py-3 bg-white text-blue-600 font-medium rounded-lg hover:bg-blue-50 transition-colors focus:outline-none focus:ring-2 focus:ring-blue-300 disabled:opacity-70"
									>
										{isLoading ? (
											<span className="flex items-center justify-center">
												<svg
													className="animate-spin -ml-1 mr-2 h-4 w-4 text-blue-600"
													xmlns="http://www.w3.org/2000/svg"
													fill="none"
													viewBox="0 0 24 24"
												>
													<circle
														className="opacity-25"
														cx="12"
														cy="12"
														r="10"
														stroke="currentColor"
														strokeWidth="4"
													></circle>
													<path
														className="opacity-75"
														fill="currentColor"
														d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"
													></path>
												</svg>
												Bezig...
											</span>
										) : (
											"Inschrijven"
										)}
									</button>
								</div>
							</form>
						)}

						<p className="text-xs text-blue-100 mt-4">
							Door je in te schrijven ga je akkoord met onze privacybeleid. Je kunt je op elk moment uitschrijven.
						</p>
					</div>

					<div className="md:w-1/2 relative">
						<div className="bg-white/10 backdrop-blur-sm rounded-xl p-6 transform rotate-3 hover:rotate-0 transition-transform duration-300">
							<div className="bg-white/80 backdrop-blur-sm rounded-lg p-6 shadow-lg">
								<div className="flex items-center mb-4">
									<div className="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mr-4">
										<svg
											xmlns="http://www.w3.org/2000/svg"
											className="h-6 w-6 text-blue-600"
											fill="none"
											viewBox="0 0 24 24"
											stroke="currentColor"
										>
											<path
												strokeLinecap="round"
												strokeLinejoin="round"
												strokeWidth={2}
												d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z"
											/>
										</svg>
									</div>
									<div>
										<h3 className="font-bold text-gray-900">Exclusieve aanbiedingen</h3>
										<p className="text-sm text-gray-600">Alleen voor nieuwsbrief abonnees</p>
									</div>
								</div>

								<ul className="space-y-3">
									<li className="flex items-start">
										<svg
											xmlns="http://www.w3.org/2000/svg"
											className="h-5 w-5 text-green-500 mr-2 mt-0.5"
											fill="none"
											viewBox="0 0 24 24"
											stroke="currentColor"
										>
											<path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
										</svg>
										<span className="text-gray-700">10% korting op je eerste bestelling</span>
									</li>
									<li className="flex items-start">
										<svg
											xmlns="http://www.w3.org/2000/svg"
											className="h-5 w-5 text-green-500 mr-2 mt-0.5"
											fill="none"
											viewBox="0 0 24 24"
											stroke="currentColor"
										>
											<path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
										</svg>
										<span className="text-gray-700">Maandelijkse gezondheidsnieuws</span>
									</li>
									<li className="flex items-start">
										<svg
											xmlns="http://www.w3.org/2000/svg"
											className="h-5 w-5 text-green-500 mr-2 mt-0.5"
											fill="none"
											viewBox="0 0 24 24"
											stroke="currentColor"
										>
											<path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
										</svg>
										<span className="text-gray-700">Vroege toegang tot nieuwe producten</span>
									</li>
									<li className="flex items-start">
										<svg
											xmlns="http://www.w3.org/2000/svg"
											className="h-5 w-5 text-green-500 mr-2 mt-0.5"
											fill="none"
											viewBox="0 0 24 24"
											stroke="currentColor"
										>
											<path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
										</svg>
										<span className="text-gray-700">Seizoensgebonden aanbiedingen</span>
									</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	)
}
