"use client"

import { useState } from "react"
import { Send } from "lucide-react"
import { toast } from "sonner"

export default function NewsletterBanner() {
	const [email, setEmail] = useState("")
	const [isSubmitting, setIsSubmitting] = useState(false)

	const handleSubmit = (e) => {
		e.preventDefault()

		if (!email || !/\S+@\S+\.\S+/.test(email)) {
			toast.error("Voer een geldig e-mailadres in")
			return
		}

		setIsSubmitting(true)

		// Simulate API call
		setTimeout(() => {
			toast.success("Bedankt voor uw aanmelding!")
			setEmail("")
			setIsSubmitting(false)
		}, 1000)
	}

	return (
		<section className="py-16 relative overflow-hidden">
			<div className="absolute inset-0 bg-gradient-to-br from-[#1eaaff] to-[#0071e6]"></div>

			{/* Background elements */}
			<div className="absolute top-0 left-0 w-full h-full overflow-hidden">
				<div className="absolute top-20 left-20 w-64 h-64 rounded-full bg-white opacity-10 blur-[100px]"></div>
				<div className="absolute bottom-10 right-10 w-96 h-96 rounded-full bg-[#00e889] opacity-10 blur-[120px]"></div>
				<div className="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-full h-32 bg-[url('/wave-pattern.png')] bg-repeat-x opacity-5"></div>
			</div>

			{/* <div className="container mx-auto px-4 relative z-10">
				<div className="max-w-3xl mx-auto text-center text-white">
					<h2 className="text-3xl font-bold mb-4">Blijf op de hoogte</h2>
					<p className="mb-8 opacity-90">
						Schrijf je in voor onze nieuwsbrief en ontvang exclusieve aanbiedingen, updates over nieuwe producten en
						handige tips.
					</p>

					<form onSubmit={handleSubmit} className="flex flex-col sm:flex-row gap-4 max-w-lg mx-auto">
						<input
							type="email"
							placeholder="Uw e-mailadres"
							value={email}
							onChange={(e) => setEmail(e.target.value)}
							className="flex-1 px-6 py-3 rounded-full text-gray-800 focus:outline-none focus:ring-2 focus:ring-white"
						/>
						<button
							type="submit"
							disabled={isSubmitting}
							className="px-6 py-3 bg-white text-[#1eaaff] font-medium rounded-full hover:bg-gray-100 transition-colors duration-300 flex items-center justify-center shadow-lg"
						>
							{isSubmitting ? (
								<span className="flex items-center">
									<svg
										className="animate-spin -ml-1 mr-2 h-4 w-4 text-[#1eaaff]"
										xmlns="http://www.w3.org/2000/svg"
										fill="none"
										viewBox="0 0 24 24"
									>
										<circle
											className="opacity-25"
											cx="12"
											cy="12"
											r="10"
											stroke="currentColor"
											strokeWidth="4"
										></circle>
										<path
											className="opacity-75"
											fill="currentColor"
											d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"
										></path>
									</svg>
									Verzenden...
								</span>
							) : (
								<span className="flex items-center">
									Aanmelden
									<Send size={16} className="ml-2" />
								</span>
							)}
						</button>
					</form>

					<p className="mt-4 text-sm opacity-80">We respecteren uw privacy. U kunt zich op elk moment uitschrijven.</p>
				</div>
			</div> */}
		</section>
	)
}
