"use client"

import { useState, useEffect } from "react"
import Link from "next/link"
import Image from "next/image"
import { ArrowRight } from "lucide-react"

export default function CategoryShowcase() {
	const [isVisible, setIsVisible] = useState(false)

	useEffect(() => {
		const observer = new IntersectionObserver(
			([entry]) => {
				if (entry.isIntersecting) {
					setIsVisible(true)
				}
			},
			{ threshold: 0.1 },
		)

		const element = document.getElementById("category-showcase")
		if (element) {
			observer.observe(element)
		}

		return () => {
			if (element) {
				observer.unobserve(element)
			}
		}
	}, [])

	const categories = [
		{
			id: 1,
			name: "Slaappillen",
			slug: "shop",
			description: "Medicijnen die helpen bij slaapproblemen",
			image: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSIf45XV42txbzD_LxA8ny7EeMQoiIzdA7PNg&s",
			color: "from-[#1eaaff] to-[#0071e6]",
		},
		{
			id: 3,
			name: "Benzodiazepinen",
			slug: "shop",
			description: "Kalmeringsmiddelen en angstremmers",
			image: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSNBUjqBgTS3cHBZPNeM71EVE6dkSi03DoYeg&s",
			color: "from-[#00e889] to-[#00985a]",
		},
	]

	return (
		<section id="category-showcase" className="py-16 bg-white relative overflow-hidden">
			{/* Background elements */}
			<div className="absolute inset-0 bg-[url('/grid-pattern.png')] bg-center opacity-5"></div>

			<div className="container mx-auto px-4">
				<div className="text-center mb-12">
					<h2 className="text-3xl font-bold mb-4">
						Ontdek onze{" "}
						<span className="bg-clip-text text-transparent bg-gradient-to-r from-[#1eaaff] to-[#0071e6]">
							categorieën
						</span>
					</h2>
					<p className="text-gray-600 max-w-2xl mx-auto">
						Vind precies wat u nodig heeft in ons uitgebreide assortiment medicijnen
					</p>
				</div>

				<div className="grid grid-cols-1 md:grid-cols-3 gap-8">
					{categories.map((category, index) => (
						<div
							key={category.id}
							className={`rounded-xl overflow-hidden shadow-lg hover:shadow-xl transition-all duration-500 group ${isVisible ? "animate-scale-up" : "opacity-0"}`}
							style={{ animationDelay: `${index * 0.2}s` }}
						>
							<Link href={`/${category.slug}`}>
								<div className="relative h-64 overflow-hidden">
									<div
										className={`absolute inset-0 bg-gradient-to-br ${category.color} opacity-90 group-hover:opacity-100 transition-opacity duration-300`}
									></div>
									<Image
										src={category.image || "/placeholder.svg"}
										alt={category.name}
										fill
										className="object-cover mix-blend-overlay"
									/>
									<div className="absolute inset-0 flex flex-col justify-end p-6 text-white">
										<h3 className="text-2xl font-bold mb-2">{category.name}</h3>
										<p className="text-white/80 mb-4">{category.description}</p>
										<div className="flex items-center text-sm font-medium">
											<span>Bekijk producten</span>
											<ArrowRight
												size={16}
												className="ml-2 transform group-hover:translate-x-1 transition-transform duration-300"
											/>
										</div>
									</div>
								</div>
							</Link>
						</div>
					))}
				</div>
			</div>
		</section>
	)
}
