import Link from "next/link"

const Categories = () => {
  const categories = [
    {
      id: "cat_1",
      name: "Slaappillen",
      slug: "slaappillen",
      description: "Medicijnen ter bevordering van een gezonde nachtrust en behandeling van slaapstoornissen.",
      image: "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTq8BOakvPffcqVvJlQoysmyxffSgpwFWYMew&s",
      count: 12,
    },
    {
      id: "cat_2",
      name: "Angstremmers",
      slug: "angstremmers",
      description: "Medicijnen gericht op het verminderen van angst- en paniekaanvallen.",
      image: "/placeholder.svg?height=800&width=600&query=anxiety%20medication",
      count: 8,
    },
    {
      id: "cat_3",
      name: "Pijnstillers",
      slug: "pijnstillers",
      description: "Medicatie voor het verlichten van acute en chronische pijnklachten.",
      image: "/placeholder.svg?height=800&width=600&query=pain%20medication",
      count: 15,
    },
    {
      id: "cat_4",
      name: "Benzodiazepinen",
      slug: "benzodiazepinen",
      description: "Medicijnen met kalmerende, slaapverwekkende en spierontspannende werking.",
      image: "/placeholder.svg?height=800&width=600&query=benzodiazepine%20medication",
      count: 10,
    },
    {
      id: "cat_5",
      name: "Erectiepillen",
      slug: "erectiepillen",
      description: "Medicijnen en behandelingen voor erectieproblemen en seksuele gezondheid bij mannen.",
      image: "/placeholder.svg?height=800&width=600&query=erectile%20medication",
      count: 6,
    },
    {
      id: "cat_6",
      name: "Antidepressiva",
      slug: "antidepressiva",
      description: "Medicijnen voor de behandeling van depressie, angststoornissen en andere psychische aandoeningen.",
      image: "/placeholder.svg?height=800&width=600&query=antidepressant%20medication",
      count: 9,
    },
  ]

  return (
    <section className="py-20 bg-gray-50">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <span className="text-purple-600 font-semibold text-sm uppercase tracking-wider">Ons assortiment</span>
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mt-2 mb-4">Ontdek onze categorieën</h2>
          <p className="text-gray-600 max-w-2xl mx-auto">
            Bekijk ons uitgebreide assortiment medicijnen voor verschillende behoeften. Alle producten zijn van hoge
            kwaliteit en worden discreet geleverd.
          </p>
        </div>

        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
          {categories.map((category) => (
            <Link
              href={`/category/${category.slug}`}
              key={category.id}
              className="group relative h-80 overflow-hidden rounded-xl shadow-lg"
            >
              {/* Background Image */}
              <div className="absolute inset-0 bg-gray-900">
                <img
                  src={category.image || "/placeholder.svg"}
                  alt={category.name}
                  className="w-full h-full object-cover opacity-70 group-hover:opacity-50 group-hover:scale-110 transition-all duration-500"
                />
              </div>

              {/* Content */}
              <div className="absolute inset-0 flex flex-col justify-end p-6 bg-gradient-to-t from-black/80 via-black/50 to-transparent">
                <div className="mb-2">
                  <span className="inline-block bg-purple-600 text-white text-xs font-semibold px-2.5 py-1 rounded-full">
                    {category.count} producten
                  </span>
                </div>
                <h3 className="text-white text-2xl font-bold mb-2 group-hover:text-purple-300 transition-colors">
                  {category.name}
                </h3>
                <p className="text-gray-300 mb-4 line-clamp-2">{category.description}</p>
                <div className="flex items-center text-purple-400 font-medium group-hover:text-purple-300 transition-colors">
                  Bekijk producten
                  <svg
                    className="w-5 h-5 ml-2 transform group-hover:translate-x-1 transition-transform"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M14 5l7 7m0 0l-7 7m7-7H3" />
                  </svg>
                </div>
              </div>
            </Link>
          ))}
        </div>
      </div>
    </section>
  )
}

export default Categories
