"use client"

import { useState } from "react"
import { ShoppingCart, Check } from "lucide-react"
import { useCart } from "@/context/CartContext"

export default function AddToCartButton({ id, name, price, image, className, iconOnly = false, icon }) {
  const [isAdded, setIsAdded] = useState(false)
  const { addToCart } = useCart()

  const handleAddToCart = () => {
    addToCart({ id, name, price, image, quantity: 1 })
    setIsAdded(true)

    setTimeout(() => {
      setIsAdded(false)
    }, 2000)
  }

  return (
    <button onClick={handleAddToCart} className={className} disabled={isAdded}>
      {iconOnly ? (
        isAdded ? (
          <Check size={18} />
        ) : (
          icon || <ShoppingCart size={18} />
        )
      ) : (
        <span className="flex items-center justify-center">
          {isAdded ? (
            <>
              <Check size={18} className="mr-2" />
              Toegevoegd
            </>
          ) : (
            <>
              <ShoppingCart size={18} className="mr-2" />
              In winkelwagen
            </>
          )}
        </span>
      )}
    </button>
  )
}
